<?php

namespace NumberToWords\NumberTransformer;

class AlbanianNumberTransformerTest extends NumberTransformerTest
{
    public function setUp()
    {
        $this->numberTransformer = new AlbanianNumberTransformer();
    }

    public function providerItConvertsNumbersToWords()
    {
        return [
            [-3, 'minus tre'],
            [0, 'zero'],
            [1, 'një'],
            [3, 'tre'],
            [8, 'tetë'],
            [9, 'nëntë'],
            [10, 'dhjetë'],
            [11, 'njëmbëdhjetë'],
            [12, 'dymbëdhjetë'],
            [16, 'gjashtëmbëdhjetë'],
            [19, 'nëntëmbëdhjetë'],
            [20, 'njëzet'],
            [21, 'njëzet e një'],
            [25, 'njëzet e pesë'],
            [26, 'njëzet e gjashtë'],
            [30, 'tridhjetë'],
            [31, 'tridhjetë e një'],
            [40, 'katërdhjetë'],
            [43, 'katërdhjetë e tre'],
            [50, 'pesëdhjetë'],
            [55, 'pesëdhjetë e pesë'],
            [58, 'pesëdhjetë e tetë'],
            [60, 'gjashtëdhjetë'],
            [67, 'gjashtëdhjetë e shtatë'],
            [70, 'shtatëdhjetë'],
            [79, 'shtatëdhjetë e nëntë'],
            [80, 'tetëdhjetë'],
            [90, 'nëntëdhjetë'],
            [99, 'nëntëdhjetë e nëntë'],
            [100, 'njëqind'],
            [101, 'njëqind e një'],
            [102, 'njëqind e dy'],
            [111, 'njëqind e njëmbëdhjetë'],
            [113, 'njëqind e trembëdhjetë'],
            [120, 'njëqind e njëzet'],
            [121, 'njëqind e njëzet e një'],
            [199, 'njëqind e nëntëdhjetë e nëntë'],
            [203, 'dyqind e tre'],
            [229, 'dyqind e njëzet e nëntë'],
            [287, 'dyqind e tetëdhjetë e shtatë'],
            [300, 'treqind'],
            [356, 'treqind e pesëdhjetë e gjashtë'],
            [410, 'katërqind e dhjetë'],
            [434, 'katërqind e tridhjetë e katër'],
            [500, 'pesëqind'],
            [578, 'pesëqind e shtatëdhjetë e tetë'],
            [660, 'gjashtëqind e gjashtëdhjetë'],
            [666, 'gjashtëqind e gjashtëdhjetë e gjashtë'],
            [689, 'gjashtëqind e tetëdhjetë e nëntë'],
            [729, 'shtatëqind e njëzet e nëntë'],
            [894, 'tetëqind e nëntëdhjetë e katër'],
            [900, 'nëntëqind'],
            [909, 'nëntëqind e nëntë'],
            [919, 'nëntëqind e nëntëmbëdhjetë'],
            [990, 'nëntëqind e nëntëdhjetë'],
            [999, 'nëntëqind e nëntëdhjetë e nëntë'],
            [1000, 'një mijë'],
            [1001, 'një mijë e një'],
            [1010, 'një mijë e dhjetë'],
            [1015, 'një mijë e pesëmbëdhjetë'],
            [1097, 'një mijë e nëntëdhjetë e shtatë'],
            [1100, 'një mijë e njëqind'],
            [1104, 'një mijë e njëqind e katër'],
            [1111, 'një mijë e njëqind e njëmbëdhjetë'],
            [1243, 'një mijë e dyqind e katërdhjetë e tre'],
            [2000, 'dy mijë'],
            [2385, 'dy mijë e treqind e tetëdhjetë e pesë'],
            [3766, 'tre mijë e shtatëqind e gjashtëdhjetë e gjashtë'],
            [4000, 'katër mijë'],
            [4196, 'katër mijë e njëqind e nëntëdhjetë e gjashtë'],
            [4538, 'katër mijë e pesëqind e tridhjetë e tetë'],
            [5000, 'pesë mijë'],
            [5020, 'pesë mijë e njëzet'],
            [5846, 'pesë mijë e tetëqind e katërdhjetë e gjashtë'],
            [6459, 'gjashtë mijë e katërqind e pesëdhjetë e nëntë'],
            [7232, 'shtatë mijë e dyqind e tridhjetë e dy'],
            [8569, 'tetë mijë e pesëqind e gjashtëdhjetë e nëntë'],
            [9539, 'nëntë mijë e pesëqind e tridhjetë e nëntë'],
            [11000, 'njëmbëdhjetë mijë'],
            [11001, 'njëmbëdhjetë mijë e një'],
            [21000, 'njëzet e një mijë'],
            [21512, 'njëzet e një mijë e pesëqind e dymbëdhjetë'],
            [90000, 'nëntëdhjetë mijë'],
            [92100, 'nëntëdhjetë e dy mijë e njëqind'],
            [212112, 'dyqind e dymbëdhjetë mijë e njëqind e dymbëdhjetë'],
            [720018, 'shtatëqind e njëzet mijë e tetëmbëdhjetë'],
            [999000, 'nëntëqind e nëntëdhjetë e nëntë mijë'],
            [999999, 'nëntëqind e nëntëdhjetë e nëntë mijë e nëntëqind e nëntëdhjetë e nëntë'],
            [1000000, 'një milion'],
            [1001001, 'një milion e një mijë e një'],
            [2000000, 'dy milion'],
            [3248518, 'tre milion e dyqind e katërdhjetë e tetë mijë e pesëqind e tetëmbëdhjetë'],
            [4000000, 'katër milion'],
            [5000000, 'pesë milion'],
            [999000000, 'nëntëqind e nëntëdhjetë e nëntë milion'],
            [999000999, 'nëntëqind e nëntëdhjetë e nëntë milion e nëntëqind e nëntëdhjetë e nëntë'],
            [999999000, 'nëntëqind e nëntëdhjetë e nëntë milion e nëntëqind e nëntëdhjetë e nëntë mijë'],
            [999999999, 'nëntëqind e nëntëdhjetë e nëntë milion e nëntëqind e nëntëdhjetë e nëntë mijë e nëntëqind e nëntëdhjetë e nëntë'],
            [-232129539, 'minus dyqind e tridhjetë e dy milion e njëqind e njëzet e nëntë mijë e pesëqind e tridhjetë e nëntë'],
            [1174315110, 'një miliard e njëqind e shtatëdhjetë e katër milion e treqind e pesëmbëdhjetë mijë e njëqind e dhjetë'],
            [1174315119, 'një miliard e njëqind e shtatëdhjetë e katër milion e treqind e pesëmbëdhjetë mijë e njëqind e nëntëmbëdhjetë'],
            [1800000006, 'një miliard e tetëqind milion e gjashtë'],
            [15174315119, 'pesëmbëdhjetë miliard e njëqind e shtatëdhjetë e katër milion e treqind e pesëmbëdhjetë mijë e njëqind e nëntëmbëdhjetë'],
            [35174315119, 'tridhjetë e pesë miliard e njëqind e shtatëdhjetë e katër milion e treqind e pesëmbëdhjetë mijë e njëqind e nëntëmbëdhjetë'],
            [935174315119, 'nëntëqind e tridhjetë e pesë miliard e njëqind e shtatëdhjetë e katër milion e treqind e pesëmbëdhjetë mijë e njëqind e nëntëmbëdhjetë'],
            [2935174315119, 'dy bilion e nëntëqind e tridhjetë e pesë miliard e njëqind e shtatëdhjetë e katër milion e treqind e pesëmbëdhjetë mijë e njëqind e nëntëmbëdhjetë'],
        ];
    }
}
