@extends('backend.layout.main')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.5/xlsx.full.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.4.0/jspdf.umd.min.js"></script>

@section('content')

<section class="forms">
    <div class="container-fluid">
        <div class="card">
            <div class="card-header mt-2">
                <h3 class="text-center">Quotation Inventory</h3>
            </div>
            <div class="col-sm-12">
                <br>
                <form action="{{route('report.filter.quotation')}}" method="post">
                @csrf
                  <div class="row">
                    <div class="col-xl-4 col-md-6 col-sm-12 mb-4">
                    <input type="date" class="form-control" id="start-date" name="start-date" required> 
                    </div>
                    <div class="col-xl-4 col-md-6 col-sm-12 mb-4">
                    <input type="date" class="form-control" id="end-date" name="end-date" required>
                    </div>
                    <div class="col-xl-4 col-md-6 col-sm-12 mb-4">
                    <button type="submit" class="btn btn-primary">Filter</button>
                    </div>
                  </div>
                  </form>
            </div>
            <div class="row mb-3">
                <div class="col-md-4 offset-md-1 mt-4">
                    <div class="form-group row">
                        <label class="d-tc mt-2"><strong>Sreach by Keyword</strong> &nbsp;</label>
                        <div class="d-tc">
                            <div class="input-group">
                                <!-- Add your search input field here -->
                                <input type="text" class="form-control" id="searchInput" placeholder="Search...">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
              <button onclick="exportToExcel()" class="btn-pos btn-sm" style="width: 18%; position: relative; margin-bottom: 30px; left: 72px;">Export to Excel</button>
            <button onclick="exportToPDF()" hidden>Export to PDF</button>

            <div class="table-responsive" style="padding:0px 25px;">
                <table id="report-table" class="table table-hover">
                     <thead>
                <tr>
                    <th>Supplier Name</th>
                    <th>Customer Name</th>
                    <th>Reference No</th>
                    <th>Product Name</th>
                    <th>Qty</th>
                    <th>Unit Price</th>
                    <th>Discount</th>
                    <th>VAT</th>
                    <th>Grand Total</th>
                    <th>Created At</th>
                </tr>
            </thead>
            <tbody>
                @foreach($datas as $data)
                <tr>
                    <td>{{ $data->supplier_name }}</td>
                    <td>{{ $data->customer_name }}</td>
                    <td>{{ $data->reference_no }}</td>
                    <td>{{ $data->product_name }}</td>
                    <td>{{ $data->qty }} {{ $data->unit_code }}</td>
                    <td>{{ number_format($data->net_unit_price, 3, '.', '.') }}</td>
                    <td>{{ number_format($data->discount, 3, '.', '.') }}</td>
                    <td>{{ number_format($data->tax, 3, '.', '.') }} [{{ $data->tax_rate }}%]</td>
                    <td>{{ number_format($data->total, 3, '.', '.') }}</td>
                    <td>{{ $data->created_at }}</td>
                </tr>
                @endforeach
            </tbody>
                </table>
            </div>
        </div>
    </div>
</section>

<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script>
    $(document).ready(function() {
        // Initial calculation
        calculateTotals();

        // Key search option
        $("#searchInput").on("keyup", function() {
            var value = $(this).val().toLowerCase();

            // Reset totals
            var totalUnitPrice = 0;
            var totalTax = 0;
            var totalDiscount = 0;
            var totalGrandTotal = 0;

            // Filter rows based on search input
            $("#report-table tbody tr").each(function() {
                var isVisible = $(this).text().toLowerCase().indexOf(value) > -1;
                $(this).toggle(isVisible);

                if (isVisible) {
                    var unitPrice = parseFloat($(this).find("td:eq(4)").text().replace(",", ""));
                    var tax = parseFloat($(this).find("td:eq(6)").text().split(' ')[0].replace(",", ""));
                    var discount = parseFloat($(this).find("td:eq(5)").text().replace(",", ""));
                    var grandTotal = parseFloat($(this).find("td:eq(7)").text().replace(",", ""));

                    totalUnitPrice += isNaN(unitPrice) ? 0 : unitPrice;
                    totalTax += isNaN(tax) ? 0 : tax;
                    totalDiscount += isNaN(discount) ? 0 : discount;
                    totalGrandTotal += isNaN(grandTotal) ? 0 : grandTotal;
                }
            });

            // Update the total row at the end of the table
            $("#total-row").remove();
            $("#report-table tbody").append(
                '<tr id="total-row">' +
                '<td colspan="4"><strong>Total:</strong></td>' +
                '<td>' + totalUnitPrice.toFixed(3) + '</td>' +
                '<td>' + totalDiscount.toFixed(3) + '</td>' +
                '<td>' + totalTax.toFixed(3) + '</td>' +
                '<td>' + totalGrandTotal.toFixed(3) + '</td>' +
                '<td></td>' +
                '</tr>'
            );
        });

        // Function to calculate totals initially
        function calculateTotals() {
            var totalUnitPrice = 0;
            var totalTax = 0;
            var totalDiscount = 0;
            var totalGrandTotal = 0;

            // Iterate through each row in the table
            $("#report-table tbody tr").each(function() {
                var unitPrice = parseFloat($(this).find("td:eq(4)").text().replace(",", ""));
                var tax = parseFloat($(this).find("td:eq(6)").text().split(' ')[0].replace(",", ""));
                var discount = parseFloat($(this).find("td:eq(5)").text().replace(",", ""));
                var grandTotal = parseFloat($(this).find("td:eq(7)").text().replace(",", ""));

                // Accumulate values for each column
                totalUnitPrice += isNaN(unitPrice) ? 0 : unitPrice;
                totalTax += isNaN(tax) ? 0 : tax;
                totalDiscount += isNaN(discount) ? 0 : discount;
                totalGrandTotal += isNaN(grandTotal) ? 0 : grandTotal;
            });

            // Add a new row with the totals at the end of the table
            $("#report-table tbody").append(
                '<tr id="total-row">' +
                '<td colspan="5"><strong>Total:</strong></td>' +
                '<td>' + totalUnitPrice.toFixed(3) + '</td>' +
                '<td>' + totalDiscount.toFixed(3) + '</td>' +
                '<td>' + totalTax.toFixed(3) + '</td>' +
                '<td>' + totalGrandTotal.toFixed(3) + '</td>' +
                '<td></td>' +
                '</tr>'
            );
        }
    });
    
    function exportToExcel() {
    const table = document.getElementById('report-table');
    const ws = XLSX.utils.table_to_sheet(table);
    const wb = XLSX.utils.book_new();
    XLSX.utils.book_append_sheet(wb, ws, 'Sheet1');

    const fileName = 'Sales Inventory.xlsx';
    XLSX.writeFile(wb, fileName);
}

function exportToPDF() {
    const table = document.getElementById('report-table');
    const pdf = new jsPDF();
    
    pdf.autoTable({ html: '#report-table' });
    
    const fileName = 'data.pdf';
    pdf.save(fileName);
}
</script>

@endsection


