 <?php $__env->startSection('content'); ?>
<?php if(session()->has('message')): ?>
  <div class="alert alert-success alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo e(session()->get('message')); ?></div>
<?php endif; ?>
<?php if(session()->has('not_permitted')): ?>
  <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo e(session()->get('not_permitted')); ?></div>
<?php endif; ?>

<section>
    <div class="container-fluid">
        <div class="card">
            <div class="card-header mt-2">
                <h3 class="text-center"><?php echo e(trans('file.Purchase List')); ?></h3>
            </div>
            <?php echo Form::open(['route' => 'purchases.index', 'method' => 'get']); ?>

            <div class="row ml-1 mt-2">
                <div class="col-md-3">
                    <div class="form-group">
                        <label><strong><?php echo e(trans('file.Date')); ?></strong></label>
                        <input type="text" class="daterangepicker-field form-control" value="<?php echo e($starting_date); ?> To <?php echo e($ending_date); ?>" required />
                        <input type="hidden" name="starting_date" value="<?php echo e($starting_date); ?>" />
                        <input type="hidden" name="ending_date" value="<?php echo e($ending_date); ?>" />
                    </div>
                </div>
                <div class="col-md-3 <?php if(\Auth::user()->role_id > 2): ?><?php echo e('d-none'); ?><?php endif; ?>" hidden>
                    <div class="form-group">
                        <label><strong><?php echo e(trans('file.Warehouse')); ?></strong></label>
                        <select id="warehouse_id" name="warehouse_id" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" >
                            <option value="0"><?php echo e(trans('file.All Warehouse')); ?></option>
                            <?php $__currentLoopData = $lims_warehouse_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($warehouse->id); ?>"><?php echo e($warehouse->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label><strong><?php echo e(trans('file.Purchase Status')); ?></strong></label>
                        <select id="purchase-status" class="form-control" name="purchase_status">
                            <option value="0"><?php echo e(trans('file.All')); ?></option>
                            <option value="1"><?php echo e(trans('file.Recieved')); ?></option>
                            <option value="2"><?php echo e(trans('file.Partial')); ?></option>
                            <option value="3"><?php echo e(trans('file.Pending')); ?></option>
                            <option value="4"><?php echo e(trans('file.Ordered')); ?></option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label><strong><?php echo e(trans('file.Payment Status')); ?></strong></label>
                        <select id="payment-status" class="form-control" name="payment_status">
                            <option value="0"><?php echo e(trans('file.All')); ?></option>
                            <option value="1"><?php echo e(trans('file.Due')); ?></option>
                            <option value="2"><?php echo e(trans('file.Paid')); ?></option>
                        </select>
                    </div>
                </div>
                <div class="col-md-2 mt-3">
                    <div class="form-group">
                        <button class="btn btn-primary" id="filter-btn" type="submit"><?php echo e(trans('file.submit')); ?></button>
                    </div>
                </div>
            </div>
            <?php echo Form::close(); ?>

        </div>
        <?php if(in_array("purchases-add", $all_permission)): ?>
            <a href="<?php echo e(route('purchases.create')); ?>" class="btn btn-info"><i class="dripicons-plus"></i> <?php echo e(trans('file.Add Purchase')); ?></a>&nbsp;
            <a href="<?php echo e(url('purchases/purchase_by_csv')); ?>" class="btn btn-primary"><i class="dripicons-copy"></i> <?php echo e(trans('file.Import Purchase')); ?></a>
        <?php endif; ?>
    </div>
    <div class="table-responsive">
        <table id="purchase-table" class="table purchase-list" style="width: 100%">
            <thead>
                <tr>
                    <th class="not-exported"></th>
                    <th><?php echo e(trans('file.Date')); ?></th>
                    <th><?php echo e(trans('file.reference')); ?></th>
                    <th><?php echo e(trans('file.Supplier')); ?></th>
                    <th><?php echo e(trans('file.Purchase Status')); ?></th>
                    <th>Total VAT</th>
                    <th><?php echo e(trans('file.grand total')); ?></th>
                    <th><?php echo e(trans('file.Returned Amount')); ?></th>
                    <th><?php echo e(trans('file.Paid')); ?></th>
                    <th><?php echo e(trans('file.Due')); ?></th>
                    <th><?php echo e(trans('file.Payment Status')); ?></th>
                    <?php $__currentLoopData = $custom_fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fieldName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <th><?php echo e($fieldName); ?></th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <th class="not-exported"><?php echo e(trans('file.action')); ?></th>
                </tr>
            </thead>

            <tfoot class="tfoot active">
                <th></th>
                <th><?php echo e(trans('file.Total')); ?></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <?php $__currentLoopData = $custom_fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fieldName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <th></th>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <th></th>
            </tfoot>
        </table>
    </div>
</section>

<div id="purchase-details" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" class="modal fade text-left print-container">
    <div role="document" class="modal-dialog">
      <div class="modal-content">
        <div class="container mt-3 pb-2 border-bottom">
            <div class="row">
                <div class="col-md-6 d-print-none">
                    <button id="print-btn" type="button" class="btn btn-default btn-sm"><i class="dripicons-print"></i> <?php echo e(trans('file.Print')); ?></button>
                    <button onclick="printContent()" hidden>Print</button>

                </div>
                <div class="col-md-6 d-print-none">
                    <button type="button" id="close-btn" data-dismiss="modal" aria-label="Close" class="close"><span aria-hidden="true"><i class="dripicons-cross"></i></span></button>
                </div>
                <div class="col-md-12">
                    <h3 id="exampleModalLabel" class="modal-title text-center">
                    <?php if($general_setting->site_logo): ?>
                    <a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(url('logo', $general_setting->site_logo)); ?>" width="115" style="width: 30%;" hidden></a>
                    <img src="<?php echo e(asset('logo/invocie_header.png')); ?>" alt="Image" style = "width: 100%;">

                    <?php else: ?>
                    <a href="<?php echo e(url('/')); ?>"><h1 class="d-inline"><?php echo e($general_setting->site_title); ?></h1></a>
                    <?php endif; ?>
                    </h3>
                </div>
                <div class="col-md-12 text-center">
                    <i style="font-size: 17px;"><?php echo e(trans('file.Purchase Details')); ?></i>
                </div>
            </div>
        </div>
            <div id="purchase-content" class="modal-body"></div>
            <br>
            <table class="table table-bordered product-purchase-list">
                <thead>
                    <th>#</th>
                    <th><?php echo e(trans('file.product')); ?></th>
                    <th>Brand</th>
                    <th>Qty</th>
                    <th>UOM</th>
                    <th><?php echo e(trans('file.Unit Cost')); ?></th>
                    <th><?php echo e(trans('file.Tax')); ?></th>
                    <th><?php echo e(trans('file.Discount')); ?></th>
                    <th><?php echo e(trans('file.Subtotal')); ?></th>
                </thead>
                <tbody>
                </tbody>
            </table>
            <div id="purchase-footer" class="modal-body"></div>
      </div>
    </div>
</div>

<div id="view-payment" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" class="modal fade text-left">
    <div role="document" class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 id="exampleModalLabel" class="modal-title"><?php echo e(trans('file.All Payment')); ?></h5>
                <button type="button" data-dismiss="modal" aria-label="Close" class="close"><span aria-hidden="true"><i class="dripicons-cross"></i></span></button>
            </div>
            <div class="modal-body">
                <table class="table table-hover payment-list">
                    <thead>
                        <tr>
                            <th><?php echo e(trans('file.date')); ?></th>
                            <th><?php echo e(trans('file.Reference No')); ?></th>
                            <th>Purchase Reference</th>
                            <th><?php echo e(trans('file.Account')); ?></th>
                            <th><?php echo e(trans('file.Amount')); ?></th>
                            <th><?php echo e(trans('file.Paid By')); ?></th>
                            <th><?php echo e(trans('file.action')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div id="add-payment" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" class="modal fade text-left">
    <div role="document" class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 id="exampleModalLabel" class="modal-title"><?php echo e(trans('file.Add Payment')); ?></h5>
                <button type="button" data-dismiss="modal" aria-label="Close" class="close"><span aria-hidden="true"><i class="dripicons-cross"></i></span></button>
            </div>
            <div class="modal-body">
                <?php echo Form::open(['route' => 'purchase.add-payment', 'method' => 'post', 'class' => 'payment-form' ]); ?>

                    <div class="row">
                        <input type="hidden" name="balance">
                        <div class="col-md-6">
                            <label><?php echo e(trans('file.Recieved Amount')); ?> *</label>
                            <input type="text" name="paying_amount" class="form-control numkey"  step="any" required>
                        </div>
                        <div class="col-md-6">
                            <label><?php echo e(trans('file.Paying Amount')); ?> *</label>
                            <input type="text" id="amount" name="amount" class="form-control"  step="any" required>
                        </div>
                        <div class="col-md-6 mt-1">
                            <label><?php echo e(trans('file.Change')); ?> : </label>
                            <p class="change ml-2"><?php echo e(number_format(0, $general_setting->decimal, '.', '')); ?></p>
                        </div>
                        <div class="col-md-6 mt-1">
                            <label><?php echo e(trans('file.Paid By')); ?></label>
                            <select name="paid_by_id" class="form-control">
                                <option value="1">Cash</option>
                                <option value="3">Credit Card</option>
                                <option value="4">Cheque</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group mt-2">
                        <div class="card-element" class="form-control">
                        </div>
                        <div class="card-errors" role="alert"></div>
                    </div>
                    <div id="cheque">
                        <div class="form-group">
                            <label><?php echo e(trans('file.Cheque Number')); ?> *</label>
                            <input type="text" name="cheque_no" class="form-control">
                        </div>
                    </div>
                    <div class="form-group">
                        <label> <?php echo e(trans('file.Account')); ?></label>
                        <select class="form-control selectpicker" name="account_id">
                        <?php $__currentLoopData = $lims_account_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($account->is_default): ?>
                            <option selected value="<?php echo e($account->id); ?>"><?php echo e($account->name); ?> [<?php echo e($account->account_no); ?>]</option>
                            <?php else: ?>
                            <option value="<?php echo e($account->id); ?>"><?php echo e($account->name); ?> [<?php echo e($account->account_no); ?>]</option>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label><?php echo e(trans('file.Payment Note')); ?></label>
                        <textarea rows="3" class="form-control" name="payment_note"></textarea>
                    </div>

                    <input type="hidden" name="purchase_id">

                    <button type="submit" class="btn btn-primary"><?php echo e(trans('file.submit')); ?></button>
                <?php echo e(Form::close()); ?>

            </div>
        </div>
    </div>
</div>

<div id="edit-payment" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" class="modal fade text-left">
    <div role="document" class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 id="exampleModalLabel" class="modal-title"><?php echo e(trans('file.Update Payment')); ?></h5>
                <button type="button" data-dismiss="modal" aria-label="Close" class="close"><span aria-hidden="true"><i class="dripicons-cross"></i></span></button>
            </div>
            <div class="modal-body">
                <?php echo Form::open(['route' => 'purchase.update-payment', 'method' => 'post', 'class' => 'payment-form' ]); ?>

                    <div class="row">
                        <div class="col-md-6">
                            <label><?php echo e(trans('file.Recieved Amount')); ?> *</label>
                            <input type="text" name="edit_paying_amount" class="form-control numkey"  step="any" required>
                        </div>
                        <div class="col-md-6">
                            <label><?php echo e(trans('file.Paying Amount')); ?> *</label>
                            <input type="text" name="edit_amount" class="form-control"  step="any" required>
                        </div>
                        <div class="col-md-6 mt-1">
                            <label><?php echo e(trans('file.Change')); ?> : </label>
                            <p class="change ml-2"><?php echo e(number_format(0, $general_setting->decimal, '.', '')); ?></p>
                        </div>
                        <div class="col-md-6 mt-1">
                            <label><?php echo e(trans('file.Paid By')); ?></label>
                            <select name="edit_paid_by_id" class="form-control selectpicker">
                                <option value="1">Cash</option>
                                <option value="3">Credit Card</option>
                                <option value="4">Cheque</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group mt-2">
                        <div class="card-element" class="form-control">
                        </div>
                        <div class="card-errors" role="alert"></div>
                    </div>
                    <div id="edit-cheque">
                        <div class="form-group">
                            <label><?php echo e(trans('file.Cheque Number')); ?> *</label>
                            <input type="text" name="edit_cheque_no" class="form-control">
                        </div>
                    </div>
                    <div class="form-group">
                        <label> <?php echo e(trans('file.Account')); ?></label>
                        <select class="form-control selectpicker" name="account_id">
                        <?php $__currentLoopData = $lims_account_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($account->id); ?>"><?php echo e($account->name); ?> [<?php echo e($account->account_no); ?>]</option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label><?php echo e(trans('file.Payment Note')); ?></label>
                        <textarea rows="3" class="form-control" name="edit_payment_note"></textarea>
                    </div>

                    <input type="hidden" name="payment_id">

                    <button type="submit" class="btn btn-primary"><?php echo e(trans('file.update')); ?></button>
                <?php echo e(Form::close()); ?>

            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script type="text/javascript">

    $(".daterangepicker-field").daterangepicker({
      callback: function(startDate, endDate, period){
        var starting_date = startDate.format('YYYY-MM-DD');
        var ending_date = endDate.format('YYYY-MM-DD');
        var title = starting_date + ' To ' + ending_date;
        $(this).val(title);
        $('input[name="starting_date"]').val(starting_date);
        $('input[name="ending_date"]').val(ending_date);
      }
    });

    $("ul#purchase").siblings('a').attr('aria-expanded','true');
    $("ul#purchase").addClass("show");
    $("ul#purchase #purchase-list-menu").addClass("active");

    <?php if($lims_pos_setting_data): ?>
        var public_key = <?php echo json_encode($lims_pos_setting_data->stripe_public_key) ?>;
    <?php endif; ?>
    var all_permission = <?php echo json_encode($all_permission) ?>;

    var purchase_id = [];
    var user_verified = <?php echo json_encode(env('USER_VERIFIED')) ?>;
    var starting_date = <?php echo json_encode($starting_date); ?>;
    var ending_date = <?php echo json_encode($ending_date); ?>;
    var warehouse_id = <?php echo json_encode($warehouse_id); ?>;
    var purchase_status = <?php echo json_encode($purchase_status); ?>;
    var payment_status = <?php echo json_encode($payment_status); ?>;

    var columns = [
        {"data": "key"},
        {"data": "date"},
        {"data": "reference_no"},
        {"data": "supplier"},
        {"data": "purchase_status"},
        {"data": "total_tax"},
        {"data": "grand_total"},
        {"data": "returned_amount"},
        {"data": "paid_amount"},
        {"data": "due"},
        {"data": "payment_status"}
    ];

    var field_name = <?php echo json_encode($field_name) ?>;
    for(i = 0; i < field_name.length; i++) {
        columns.push({"data": field_name[i]});
    }
    columns.push({"data": "options"});

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $("#warehouse_id").val(warehouse_id);
    $("#purchase-status").val(purchase_status);
    $("#payment-status").val(payment_status);

    $('.selectpicker').selectpicker('refresh');

    function confirmDelete() {
        if (confirm("Are you sure want to delete?")) {
            return true;
        }
        return false;
    }

    function confirmDeletePayment() {
        if (confirm("Are you sure want to delete? If you delete this money will be refunded")) {
            return true;
        }
        return false;
    }

    $(document).on("click", "tr.purchase-link td:not(:first-child, :last-child)", function(){
        var purchase = $(this).parent().data('purchase');
        purchaseDetails(purchase);
    });

    $(document).on("click", ".view", function(){
        var purchase = $(this).parent().parent().parent().parent().parent().data('purchase');
        purchaseDetails(purchase);
    });

    $("#print-btn").on("click", function(){
        var divContents = document.getElementById("purchase-details").innerHTML;
        var a = window.open('');
        a.document.write('<html>');
        a.document.write('<body><style>body{font-family: sans-serif;line-height: 1.15;-webkit-text-size-adjust: 100%;}.d-print-none{display:none}.text-center{text-align:center}.row{width:100%;margin-right: -15px;margin-left: -15px;}.col-md-12{width:100%;display:block;padding: 5px 15px;}.col-md-6{width: 50%;float:left;padding: 5px 15px;}table{width:100%;margin-top:30px;}th{text-aligh:left;}td{padding:10px}table, th, td{border: 1px solid black; border-collapse: collapse;}</style><style>@media print {.modal-dialog { max-width: 1000px;} }</style>');
        a.document.write(divContents);
        a.document.write('</body></html>');
        a.document.close();
        setTimeout(function(){a.close();},10);
        a.print();
    });

    $(document).on("click", "table.purchase-list tbody .add-payment", function(event) {
        $("#cheque").hide();
        $(".card-element").hide();
        $('select[name="paid_by_id"]').val(1);
        rowindex = $(this).closest('tr').index();
        var purchase_id = $(this).data('id').toString();
        var balance = $('table.purchase-list tbody tr:nth-child(' + (rowindex + 1) + ')').find('td:nth-child(9)').text();
        balance = parseFloat(balance.replace(/,/g, ''));
        $('input[name="amount"]').val(balance);
        $('input[name="balance"]').val(balance);
        $('input[name="paying_amount"]').val(balance);
        $('input[name="purchase_id"]').val(purchase_id);
    });

    $(document).on("click", "table.purchase-list tbody .get-payment", function(event) {
        var id = $(this).data('id').toString();
        $.get('purchases/getpayment/' + id, function(data) {
            $(".payment-list tbody").remove();
            var newBody = $("<tbody>");
            payment_date  = data[0];
            payment_reference = data[1];
            paid_amount = data[2];
            paying_method = data[3];
            payment_id = data[4];
            payment_note = data[5];
            cheque_no = data[6];
            change = data[7];
            paying_amount = data[8];
            account_name = data[9];
            account_id = data[10];
            reference_no = data[11];

            $.each(payment_date, function(index){
                var newRow = $("<tr>");
                var cols = '';

                cols += '<td>' + payment_date[index] + '</td>';
                cols += '<td>' + payment_reference[index] + '</td>';
                cols += '<td>' + reference_no[index] + '</td>';
                cols += '<td>' + account_name[index] + '</td>';
                cols += '<td>' + paid_amount[index] + '</td>';
                cols += '<td>' + paying_method[index] + '</td>';
                cols += '<td><div class="btn-group"><button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Action<span class="caret"></span><span class="sr-only">Toggle Dropdown</span></button><ul class="dropdown-menu edit-options dropdown-menu-right dropdown-default" user="menu">';
                if(all_permission.indexOf("purchase-payment-edit") != -1)
                    cols += '<li><button type="button" class="btn btn-link edit-btn" data-id="' + payment_id[index] +'" data-clicked=false data-toggle="modal" data-target="#edit-payment"><i class="dripicons-document-edit"></i> Edit</button></li><li class="divider"></li>';
                if(all_permission.indexOf("purchase-payment-delete") != -1)
                    cols += '<?php echo e(Form::open(['route' => 'purchase.delete-payment', 'method' => 'post'] )); ?><li><input type="hidden" name="id" value="' + payment_id[index] + '" /> <button type="submit" class="btn btn-link" onclick="return confirmDeletePayment()"><i class="dripicons-trash"></i> Delete</button></li><?php echo e(Form::close()); ?>';
                cols += '</ul></div></td>';
                newRow.append(cols);
                newBody.append(newRow);
                $("table.payment-list").append(newBody);
            });
            $('#view-payment').modal('show');
        });
    });

    $(document).on("click", "table.payment-list .edit-btn", function(event) {
        $(".edit-btn").attr('data-clicked', true);
        $(".card-element").hide();
        $("#edit-cheque").hide();
        $('#edit-payment select[name="edit_paid_by_id"]').prop('disabled', false);
        var id = $(this).data('id').toString();
        $.each(payment_id, function(index){
            if(payment_id[index] == parseFloat(id)){
                $('input[name="payment_id"]').val(payment_id[index]);
                $('#edit-payment select[name="account_id"]').val(account_id[index]);
                if(paying_method[index] == 'Cash')
                    $('select[name="edit_paid_by_id"]').val(1);
                else if(paying_method[index] == 'Credit Card'){
                    $('select[name="edit_paid_by_id"]').val(3);
                    <?php if($lims_pos_setting_data && (strlen($lims_pos_setting_data->stripe_public_key)>0) && (strlen($lims_pos_setting_data->stripe_secret_key )>0)): ?>
                        $.getScript( "public/vendor/stripe/checkout.js" );
                        $(".card-element").show();
                    <?php endif; ?>
                    $("#edit-cheque").hide();
                    $('#edit-payment select[name="edit_paid_by_id"]').prop('disabled', true);
                }
                else{
                    $('select[name="edit_paid_by_id"]').val(4);
                    $("#edit-cheque").show();
                    $('input[name="edit_cheque_no"]').val(cheque_no[index]);
                    $('input[name="edit_cheque_no"]').attr('required', true);
                }
                $('input[name="edit_date"]').val(payment_date[index]);
                $("#payment_reference").html(payment_reference[index]);
                $('input[name="edit_amount"]').val(paid_amount[index]);
                $('input[name="edit_paying_amount"]').val(paying_amount[index]);
                $('.change').text(change[index]);
                $('textarea[name="edit_payment_note"]').val(payment_note[index]);
                return false;
            }
        });
        $('.selectpicker').selectpicker('refresh');
        $('#view-payment').modal('hide');
    });

    $('select[name="paid_by_id"]').on("change", function() {
        var id = $('select[name="paid_by_id"]').val();
        $('input[name="cheque_no"]').attr('required', false);
        $(".payment-form").off("submit");
        if (id == 3) {
            $.getScript( "public/vendor/stripe/checkout.js" );
            $(".card-element").show();
            $("#cheque").hide();
        } else if (id == 4) {
            $("#cheque").show();
            $(".card-element").hide();
            $('input[name="cheque_no"]').attr('required', true);
        } else {
            $(".card-element").hide();
            $("#cheque").hide();
        }
    });

    $('input[name="paying_amount"]').on("input", function() {
        $(".change").text(parseFloat( $(this).val() - $('input[name="amount"]').val() ).toFixed(<?php echo e($general_setting->decimal); ?>));
    });
    /*

    $('input[name="amount"]').on("input", function() {
        if( $(this).val() > parseFloat($('input[name="paying_amount"]').val()) ) {
            alert('Paying amount cannot be bigger than recieved amount');
            $(this).val('');
        }
        else if( $(this).val() > parseFloat($('input[name="balance"]').val()) ) {
            alert('Paying amount cannot be bigger than due amount');
            $(this).val('');
        }
        $(".change").text(parseFloat($('input[name="paying_amount"]').val() - $(this).val()).toFixed(<?php echo e($general_setting->decimal); ?>));
    });*/

    $('select[name="edit_paid_by_id"]').on("change", function() {
        var id = $('select[name="edit_paid_by_id"]').val();
        $('input[name="edit_cheque_no"]').attr('required', false);
        $(".payment-form").off("submit");
        if (id == 3) {
            $(".edit-btn").attr('data-clicked', true);
            $.getScript( "public/vendor/stripe/checkout.js" );
            $(".card-element").show();
            $("#edit-cheque").hide();
        } else if (id == 4) {
            $("#edit-cheque").show();
            $(".card-element").hide();
            $('input[name="edit_cheque_no"]').attr('required', true);
        } else {
            $(".card-element").hide();
            $("#edit-cheque").hide();
        }
    });

    $('input[name="edit_amount"]').on("input", function() {
        if( $(this).val() > parseFloat($('input[name="edit_paying_amount"]').val()) ) {
            alert('Paying amount cannot be bigger than recieved amount');
            $(this).val('');
        }
        $(".change").text(parseFloat($('input[name="edit_paying_amount"]').val() - $(this).val()).toFixed(<?php echo e($general_setting->decimal); ?>));
    });

    $('input[name="edit_paying_amount"]').on("input", function() {
        $(".change").text(parseFloat( $(this).val() - $('input[name="edit_amount"]').val() ).toFixed(<?php echo e($general_setting->decimal); ?>));
    });

    $('#purchase-table').DataTable( {
        "processing": true,
        "serverSide": true,
        "ajax":{
            url:"purchases/purchase-data",
            data:{
                all_permission: all_permission,
                starting_date: starting_date,
                ending_date: ending_date,
                warehouse_id: warehouse_id,
                purchase_status: purchase_status,
                payment_status: payment_status
            },
            dataType: "json",
            type:"post",
            /*success:function(data){
                console.log(data);
            }*/
        },
        "createdRow": function( row, data, dataIndex ) {
            $(row).addClass('purchase-link');
            $(row).attr('data-purchase', data['purchase']);
        },
        "columns": columns,
        'language': {
            /*'searchPlaceholder': "<?php echo e(trans('file.Type date or purchase reference...')); ?>",*/
            'lengthMenu': '_MENU_ <?php echo e(trans("file.records per page")); ?>',
             "info":      '<small><?php echo e(trans("file.Showing")); ?> _START_ - _END_ (_TOTAL_)</small>',
            "search":  '<?php echo e(trans("file.Search")); ?>',
            'paginate': {
                    'previous': '<i class="dripicons-chevron-left"></i>',
                    'next': '<i class="dripicons-chevron-right"></i>'
            }
        },
        order:[['1', 'desc']],
        'columnDefs': [
            {
                "orderable": false,
                'targets': [0, 3, 4, 7, 8, 9, 10]
            },
            {
                'render': function(data, type, row, meta){
                    if(type === 'display'){
                        data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                    }

                   return data;
                },
                'checkboxes': {
                   'selectRow': true,
                   'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>'
                },
                'targets': [0]
            }
        ],
        'select': { style: 'multi',  selector: 'td:first-child'},
        'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
        dom: '<"row"lfB>rtip',
        buttons: [
            {
                extend: 'pdf',
                text: '<i title="export to pdf" class="fa fa-file-pdf-o"></i>',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                },
                action: function(e, dt, button, config) {
                    datatable_sum(dt, true);
                    $.fn.dataTable.ext.buttons.pdfHtml5.action.call(this, e, dt, button, config);
                    datatable_sum(dt, false);
                },
                footer:true
            },
            {
                extend: 'excel',
                text: '<i title="export to excel" class="dripicons-document-new"></i>',
                exportOptions: {
                    columns: ':visible:not(.not-exported)',
                    rows: ':visible'
                },
                action: function(e, dt, button, config) {
                    datatable_sum(dt, true);
                    $.fn.dataTable.ext.buttons.excelHtml5.action.call(this, e, dt, button, config);
                    datatable_sum(dt, false);
                },
                footer:true
            },
            {
                extend: 'csv',
                text: '<i title="export to csv" class="fa fa-file-text-o"></i>',
                exportOptions: {
                    columns: ':visible:not(.not-exported)',
                    rows: ':visible'
                },
                action: function(e, dt, button, config) {
                    datatable_sum(dt, true);
                    $.fn.dataTable.ext.buttons.csvHtml5.action.call(this, e, dt, button, config);
                    datatable_sum(dt, false);
                },
                footer:true
            },
            {
                extend: 'print',
                text: '<i title="print" class="fa fa-print"></i>',
                exportOptions: {
                    columns: ':visible:not(.not-exported)',
                    rows: ':visible'
                },
                action: function(e, dt, button, config) {
                    datatable_sum(dt, true);
                    $.fn.dataTable.ext.buttons.print.action.call(this, e, dt, button, config);
                    datatable_sum(dt, false);
                },
                footer:true
            },
            {
                text: '<i title="delete" class="dripicons-cross"></i>',
                className: 'buttons-delete',
                action: function ( e, dt, node, config ) {
                    if(user_verified == '1') {
                        purchase_id.length = 0;
                        $(':checkbox:checked').each(function(i){
                            if(i){
                                var purchase = $(this).closest('tr').data('purchase');
                                purchase_id[i-1] = purchase[3];
                            }
                        });
                        if(purchase_id.length && confirm("Are you sure want to delete?")) {
                            $.ajax({
                                type:'POST',
                                url:'purchases/deletebyselection',
                                data:{
                                    purchaseIdArray: purchase_id
                                },
                                success:function(data) {
                                    alert(data);
                                    //dt.rows({ page: 'current', selected: true }).deselect();
                                    dt.rows({ page: 'current', selected: true }).remove().draw(false);
                                }
                            });
                        }
                        else if(!purchase_id.length)
                            alert('Nothing is selected!');
                    }
                    else
                        alert('This feature is disable for demo!');
                }
            },
            {
                extend: 'colvis',
                text: '<i title="column visibility" class="fa fa-eye"></i>',
                columns: ':gt(0)'
            },
        ],
        drawCallback: function () {
            var api = this.api();
            datatable_sum(api, false);
        }
    });

    function datatable_sum(dt_selector, is_calling_first) {
        if (dt_selector.rows( '.selected' ).any() && is_calling_first) {
            var rows = dt_selector.rows( '.selected' ).indexes();

            $( dt_selector.column( 5 ).footer() ).html(dt_selector.cells( rows, 5, { page: 'current' } ).data().sum().toFixed(<?php echo e($general_setting->decimal); ?>));
            $( dt_selector.column( 6 ).footer() ).html(dt_selector.cells( rows, 6, { page: 'current' } ).data().sum().toFixed(<?php echo e($general_setting->decimal); ?>));
            $( dt_selector.column( 7 ).footer() ).html(dt_selector.cells( rows, 7, { page: 'current' } ).data().sum().toFixed(<?php echo e($general_setting->decimal); ?>));
            $( dt_selector.column( 8 ).footer() ).html(dt_selector.cells( rows, 8, { page: 'current' } ).data().sum().toFixed(<?php echo e($general_setting->decimal); ?>));
        }
        else {
            $( dt_selector.column( 5 ).footer() ).html(dt_selector.column( 5, {page:'current'} ).data().sum().toFixed(<?php echo e($general_setting->decimal); ?>));
            $( dt_selector.column( 6 ).footer() ).html(dt_selector.column( 6, {page:'current'} ).data().sum().toFixed(<?php echo e($general_setting->decimal); ?>));
            $( dt_selector.column( 7 ).footer() ).html(dt_selector.column( 7, {page:'current'} ).data().sum().toFixed(<?php echo e($general_setting->decimal); ?>));
            $( dt_selector.column( 8 ).footer() ).html(dt_selector.column( 8, {page:'current'} ).data().sum().toFixed(<?php echo e($general_setting->decimal); ?>));
        }
    }

    function purchaseDetails(purchase){
        var htmltext = '<div hidden><strong><?php echo e(trans("file.Date")); ?>: </strong>'+purchase[0]+'<br><strong>Purchase Order No: </strong>'+purchase[1]+'<br><strong><?php echo e(trans("file.Purchase Status")); ?>: </strong>'+purchase[2]+'<br><strong><?php echo e(trans("file.Currency")); ?>: </strong>'+purchase[26]+'</div>';
        if(purchase[27])
            htmltext += '<div hidden><br><strong><?php echo e(trans("file.Exchange Rate")); ?>: </strong>'+purchase[27]+'<br> </div>';
        else
            htmltext += '<br><strong><?php echo e(trans("file.Exchange Rate")); ?>: </strong>N/A<br>';
        if(purchase[25])
            htmltext += '<div hidden><strong><?php echo e(trans("file.Attach Document")); ?>: </strong><a href="documents/purchase/'+purchase[25]+'">Download</a><br></div>';
        htmltext += '<br><div class="row"><div class="col-md-6"><strong><?php echo e(trans("file.Date")); ?>: </strong>'+purchase[0]+'<br><strong>Purchase Order No: </strong>'+purchase[1]+'<br><strong><?php echo e(trans("file.Purchase Status")); ?>: </strong>'+purchase[2]+'<br><strong><?php echo e(trans("file.Currency")); ?>: </strong>'+purchase[27]+'<br><div hidden><strong><?php echo e(trans("file.Exchange Rate")); ?>: </strong>'+purchase[26]+'</div><br></div><div class="col-md-6"><div class="float-right"><strong>Name: </strong>'+purchase[7]+'<br><strong>Company: </strong>'+purchase[8]+'<br><strong>Email: </strong>'+purchase[9]+'<br><strong>Contact: </strong>'+purchase[10]+'<br><strong>Address: </strong>'+purchase[11]+', '+purchase[12]+'<br><strong>VAT: </strong>'+purchase[13]+'</div></div></div>';
        $(".product-purchase-list tbody").remove();
        $.get('purchases/product_purchase/' + purchase[3], function(data) {
            if(data == 'Something is wrong!') {
                var newBody = $("<tbody>");
                var newRow = $("<tr>");
                cols = '<td colspan="8">Something is wrong!</td>';
                newRow.append(cols);
                newBody.append(newRow);
            }
            else {
                var name_code = data[0];
                var qty = data[1];
                var unit_code = data[2];
                var tax = data[3];
                var tax_rate = data[4];
                var discount = data[5];
                var subtotal = data[6];
                var batch_no = data[7];
                var title = data[8];
                var newBody = $("<tbody>");
                var totalVAT = 0;
                $.each(name_code, function(index) {
                    var newRow = $("<tr>");
                    var cols = '';
                    cols += '<td><strong>' + (index+1) + '</strong></td>';
                    cols += '<td>' + name_code[index] + '</td>';
                    cols += '<td>' + title[index] + '</td>';
                    cols += '<td>' + qty[index] + '</td>';
                    cols += '<td>' + unit_code[index] + '</td>';
                    cols += '<td>'+ purchase[27] + ' ' + ((subtotal[index] - tax[index]) / qty[index]).toFixed(2) + '</td>';
                    cols += '<td>' + purchase[27] + ' ' + tax[index] + '(' + tax_rate[index] + '%)' + '</td>';
                    cols += '<td>' + discount[index] + '</td>';
                    cols += '<td>'+ purchase[27] + ' ' + ((subtotal[index] - tax[index]).toFixed(3)) + '</td>';
                    totalVAT += parseFloat(tax[index]);
                    newRow.append(cols);
                    newBody.append(newRow);
                });

                var newRow = $("<tr>");
                cols = '';
                cols += '<td colspan=6><strong><?php echo e(trans("file.Total")); ?> VAT:</strong></td>';
                cols += '<td> </td>';
                cols += '<td>' + purchase[15] + '</td>';
                cols += '<td>'+ purchase[27] + ' ' + totalVAT + '</td>';
                newRow.append(cols);
                newBody.append(newRow);

                var newRow = $("<tr hidden>");
                cols = '';
                cols += '<td colspan=8><strong><?php echo e(trans("file.Order Tax")); ?>:</strong></td>';
                cols += '<td>'+ purchase[27] + ' ' + purchase[16] + '</td>';
                newRow.append(cols);
                if (parseInt(purchase[16]) === 0) {
                    newRow.hide();
                }
                newBody.append(newRow);

                var newRow = $("<tr>");
                cols = '';
                cols += '<td colspan=8><strong><?php echo e(trans("file.Order Discount")); ?>:</strong></td>';
                cols += '<td>'+ purchase[18] + '</td>';
                newRow.append(cols);
                if (parseInt(purchase[18]) === 0) {
                    newRow.hide();
                }
                newBody.append(newRow);

                var newRow = $("<tr>");
                cols = '';
                cols += '<td colspan=8><strong><?php echo e(trans("file.Shipping Cost")); ?>:</strong></td>';
                cols += '<td>'+ purchase[27] + ' ' + purchase[19] + '</td>';
                newRow.append(cols);
                if (parseInt(purchase[19]) === 0) {
                    newRow.hide();
                }
                newBody.append(newRow);

            if (purchase[27] === "OMR") {


            function numberToWords(number) {
                    var units = ['', 'One', 'Two', 'Three', 'Four', 'Five', 'Six', 'Seven', 'Eight', 'Nine'];
                    var teens = ['', 'Eleven', 'Twelve', 'Thirteen', 'Fourteen', 'Fifteen', 'Sixteen', 'Seventeen', 'Eighteen', 'Nineteen'];
                    var tens = ['', 'Ten', 'Twenty', 'Thirty', 'Forty', 'Fifty', 'Sixty', 'Seventy', 'Eighty', 'Ninety'];
                
                    function convertTwoDigit(num) {
                        if (num < 10) {
                            return units[num];
                        } else if (num < 20) {
                            return teens[num - 10];
                        } else {
                            return tens[Math.floor(num / 10)] + (num % 10 !== 0 ? ' ' + units[num % 10] : '');
                        }
                    }
                
                    function convertThreeDigit(num) {
                        if (num < 100) {
                            return convertTwoDigit(num);
                        } else {
                            return units[Math.floor(num / 100)] + ' Hundred' + (num % 100 !== 0 ? ' ' + convertTwoDigit(num % 100) : '');
                        }
                    }
                
                    function convertThousand(num) {
                        if (num < 1000) {
                            return convertThreeDigit(num);
                        } else {
                            return convertThreeDigit(Math.floor(num / 1000)) + ' Thousand' + (num % 1000 !== 0 ? ' ' + convertThreeDigit(num % 1000) : '');
                        }
                    }
                
                    function getCurrencyWords(amount) {
                        return amount === 1 ? 'Riyal' : 'Oman Riyals';
                    }
                
                    var words = '';
                
                    var integerPart = Math.floor(number);
                    var decimalPart = Math.round((number - integerPart) * 1000); // Round to three decimal places
                
                    if (integerPart === 0 && decimalPart > 0) {
                        words = 'Zero';
                    } else {
                        words = convertThousand(integerPart) + ' ' + getCurrencyWords(integerPart);
                
                        if (decimalPart > 0) {
                            words += ' and ' + convertThousand(decimalPart) + ' Baisa';
                        }
                    }
                
                    return words.trim();
            }

                
            }
            else if (purchase[27] === "AED") {
                
                function numberToWords(number) {
                    var units = ['', 'One', 'Two', 'Three', 'Four', 'Five', 'Six', 'Seven', 'Eight', 'Nine'];
                    var teens = ['', 'Eleven', 'Twelve', 'Thirteen', 'Fourteen', 'Fifteen', 'Sixteen', 'Seventeen', 'Eighteen', 'Nineteen'];
                    var tens = ['', 'Ten', 'Twenty', 'Thirty', 'Forty', 'Fifty', 'Sixty', 'Seventy', 'Eighty', 'Ninety'];
                
                    function convertTwoDigit(num) {
                        if (num < 10) {
                            return units[num];
                        } else if (num < 20) {
                            return teens[num - 10];
                        } else {
                            return tens[Math.floor(num / 10)] + (num % 10 !== 0 ? ' ' + units[num % 10] : '');
                        }
                    }
                
                    function convertThreeDigit(num) {
                        if (num < 100) {
                            return convertTwoDigit(num);
                        } else {
                            return units[Math.floor(num / 100)] + ' Hundred' + (num % 100 !== 0 ? ' ' + convertTwoDigit(num % 100) : '');
                        }
                    }
                
                    function convertThousand(num) {
                        if (num < 1000) {
                            return convertThreeDigit(num);
                        } else {
                            return convertThreeDigit(Math.floor(num / 1000)) + ' Thousand' + (num % 1000 !== 0 ? ' ' + convertThreeDigit(num % 1000) : '');
                        }
                    }
                
                    function getCurrencyWords(amount) {
                        return amount === 1 ? 'Dirham' : 'Dirhams';
                    }
                
                    var words = '';
                
                    var integerPart = Math.floor(number);
                    var decimalPart = Math.round((number - integerPart) * 1000); // Round to three decimal places
                
                    if (integerPart === 0 && decimalPart > 0) {
                        words = 'Zero';
                    } else {
                        words = convertThousand(integerPart) + ' ' + getCurrencyWords(integerPart);
                
                        if (decimalPart > 0) {
                            words += ' and ' + convertThousand(decimalPart) + ' Cents';
                        }
                    }
                
                    return words.trim();
            }

                
            }
            else if (purchase[27] === "INR") {
                
                function numberToWords(number) {
                    var units = ['', 'One', 'Two', 'Three', 'Four', 'Five', 'Six', 'Seven', 'Eight', 'Nine'];
                    var teens = ['', 'Eleven', 'Twelve', 'Thirteen', 'Fourteen', 'Fifteen', 'Sixteen', 'Seventeen', 'Eighteen', 'Nineteen'];
                    var tens = ['', 'Ten', 'Twenty', 'Thirty', 'Forty', 'Fifty', 'Sixty', 'Seventy', 'Eighty', 'Ninety'];
                
                    function convertTwoDigit(num) {
                        if (num < 10) {
                            return units[num];
                        } else if (num < 20) {
                            return teens[num - 10];
                        } else {
                            return tens[Math.floor(num / 10)] + (num % 10 !== 0 ? ' ' + units[num % 10] : '');
                        }
                    }
                
                    function convertThreeDigit(num) {
                        if (num < 100) {
                            return convertTwoDigit(num);
                        } else {
                            return units[Math.floor(num / 100)] + ' Hundred' + (num % 100 !== 0 ? ' ' + convertTwoDigit(num % 100) : '');
                        }
                    }
                
                    function convertThousand(num) {
                        if (num < 1000) {
                            return convertThreeDigit(num);
                        } else {
                            return convertThreeDigit(Math.floor(num / 1000)) + ' Thousand' + (num % 1000 !== 0 ? ' ' + convertThreeDigit(num % 1000) : '');
                        }
                    }
                
                    function getCurrencyWords(amount) {
                        return amount === 1 ? 'Rupee' : 'Rupees';
                    }
                
                    var words = '';
                
                    var integerPart = Math.floor(number);
                    var decimalPart = Math.round((number - integerPart) * 1000); // Round to three decimal places
                
                    if (integerPart === 0 && decimalPart > 0) {
                        words = 'Zero';
                    } else {
                        words = convertThousand(integerPart) + ' ' + getCurrencyWords(integerPart);
                
                        if (decimalPart > 0) {
                            words += ' and ' + convertThousand(decimalPart) + ' Paise';
                        }
                    }
                
                    return words.trim();
            }

                
            }
            else if (purchase[27] === "USD") {
                
                function numberToWords(number) {
                    var units = ['', 'One', 'Two', 'Three', 'Four', 'Five', 'Six', 'Seven', 'Eight', 'Nine'];
                    var teens = ['', 'Eleven', 'Twelve', 'Thirteen', 'Fourteen', 'Fifteen', 'Sixteen', 'Seventeen', 'Eighteen', 'Nineteen'];
                    var tens = ['', 'Ten', 'Twenty', 'Thirty', 'Forty', 'Fifty', 'Sixty', 'Seventy', 'Eighty', 'Ninety'];
                
                    function convertTwoDigit(num) {
                        if (num < 10) {
                            return units[num];
                        } else if (num < 20) {
                            return teens[num - 10];
                        } else {
                            return tens[Math.floor(num / 10)] + (num % 10 !== 0 ? ' ' + units[num % 10] : '');
                        }
                    }
                
                    function convertThreeDigit(num) {
                        if (num < 100) {
                            return convertTwoDigit(num);
                        } else {
                            return units[Math.floor(num / 100)] + ' Hundred' + (num % 100 !== 0 ? ' ' + convertTwoDigit(num % 100) : '');
                        }
                    }
                
                    function convertThousand(num) {
                        if (num < 1000) {
                            return convertThreeDigit(num);
                        } else {
                            return convertThreeDigit(Math.floor(num / 1000)) + ' Thousand' + (num % 1000 !== 0 ? ' ' + convertThreeDigit(num % 1000) : '');
                        }
                    }
                
                    function getCurrencyWords(amount) {
                        return amount === 1 ? 'Dollar' : 'Dollars';
                    }
                
                    var words = '';
                
                    var integerPart = Math.floor(number);
                    var decimalPart = Math.round((number - integerPart) * 1000); // Round to three decimal places
                
                    if (integerPart === 0 && decimalPart > 0) {
                        words = 'Zero';
                    } else {
                        words = convertThousand(integerPart) + ' ' + getCurrencyWords(integerPart);
                
                        if (decimalPart > 0) {
                            words += ' and ' + convertThousand(decimalPart) + ' Cents';
                        }
                    }
                
                    return words.trim();
            }

                
            }
            
            else if (purchase[27] === "QAR") {
                
                function numberToWords(number) {
                    var units = ['', 'One', 'Two', 'Three', 'Four', 'Five', 'Six', 'Seven', 'Eight', 'Nine'];
                    var teens = ['', 'Eleven', 'Twelve', 'Thirteen', 'Fourteen', 'Fifteen', 'Sixteen', 'Seventeen', 'Eighteen', 'Nineteen'];
                    var tens = ['', 'Ten', 'Twenty', 'Thirty', 'Forty', 'Fifty', 'Sixty', 'Seventy', 'Eighty', 'Ninety'];
                
                    function convertTwoDigit(num) {
                        if (num < 10) {
                            return units[num];
                        } else if (num < 20) {
                            return teens[num - 10];
                        } else {
                            return tens[Math.floor(num / 10)] + (num % 10 !== 0 ? ' ' + units[num % 10] : '');
                        }
                    }
                
                    function convertThreeDigit(num) {
                        if (num < 100) {
                            return convertTwoDigit(num);
                        } else {
                            return units[Math.floor(num / 100)] + ' Hundred' + (num % 100 !== 0 ? ' ' + convertTwoDigit(num % 100) : '');
                        }
                    }
                
                    function convertThousand(num) {
                        if (num < 1000) {
                            return convertThreeDigit(num);
                        } else {
                            return convertThreeDigit(Math.floor(num / 1000)) + ' Thousand' + (num % 1000 !== 0 ? ' ' + convertThreeDigit(num % 1000) : '');
                        }
                    }
                
                    function getCurrencyWords(amount) {
                        return amount === 1 ? 'Riyal' : 'Riyals';
                    }
                
                    var words = '';
                
                    var integerPart = Math.floor(number);
                    var decimalPart = Math.round((number - integerPart) * 1000); // Round to three decimal places
                
                    if (integerPart === 0 && decimalPart > 0) {
                        words = 'Zero';
                    } else {
                        words = convertThousand(integerPart) + ' ' + getCurrencyWords(integerPart);
                
                        if (decimalPart > 0) {
                            words += ' and ' + convertThousand(decimalPart) + ' Dirhams';
                        }
                    }
                
                    return words.trim();
            }

                
            }
            
            else if (purchase[27] === "KWD") {
                
                function numberToWords(number) {
                    var units = ['', 'One', 'Two', 'Three', 'Four', 'Five', 'Six', 'Seven', 'Eight', 'Nine'];
                    var teens = ['', 'Eleven', 'Twelve', 'Thirteen', 'Fourteen', 'Fifteen', 'Sixteen', 'Seventeen', 'Eighteen', 'Nineteen'];
                    var tens = ['', 'Ten', 'Twenty', 'Thirty', 'Forty', 'Fifty', 'Sixty', 'Seventy', 'Eighty', 'Ninety'];
                
                    function convertTwoDigit(num) {
                        if (num < 10) {
                            return units[num];
                        } else if (num < 20) {
                            return teens[num - 10];
                        } else {
                            return tens[Math.floor(num / 10)] + (num % 10 !== 0 ? ' ' + units[num % 10] : '');
                        }
                    }
                
                    function convertThreeDigit(num) {
                        if (num < 100) {
                            return convertTwoDigit(num);
                        } else {
                            return units[Math.floor(num / 100)] + ' Hundred' + (num % 100 !== 0 ? ' ' + convertTwoDigit(num % 100) : '');
                        }
                    }
                
                    function convertThousand(num) {
                        if (num < 1000) {
                            return convertThreeDigit(num);
                        } else {
                            return convertThreeDigit(Math.floor(num / 1000)) + ' Thousand' + (num % 1000 !== 0 ? ' ' + convertThreeDigit(num % 1000) : '');
                        }
                    }
                
                    function getCurrencyWords(amount) {
                        return amount === 1 ? 'Dinar' : 'Dinars';
                    }
                
                    var words = '';
                
                    var integerPart = Math.floor(number);
                    var decimalPart = Math.round((number - integerPart) * 1000); // Round to three decimal places
                
                    if (integerPart === 0 && decimalPart > 0) {
                        words = 'Zero';
                    } else {
                        words = convertThousand(integerPart) + ' ' + getCurrencyWords(integerPart);
                
                        if (decimalPart > 0) {
                            words += ' and ' + convertThousand(decimalPart) + ' Fils';
                        }
                    }
                
                    return words.trim();
            }

                
            }
            
            else if (purchase[27] === "SAR") {
                
                function numberToWords(number) {
                    var units = ['', 'One', 'Two', 'Three', 'Four', 'Five', 'Six', 'Seven', 'Eight', 'Nine'];
                    var teens = ['', 'Eleven', 'Twelve', 'Thirteen', 'Fourteen', 'Fifteen', 'Sixteen', 'Seventeen', 'Eighteen', 'Nineteen'];
                    var tens = ['', 'Ten', 'Twenty', 'Thirty', 'Forty', 'Fifty', 'Sixty', 'Seventy', 'Eighty', 'Ninety'];
                
                    function convertTwoDigit(num) {
                        if (num < 10) {
                            return units[num];
                        } else if (num < 20) {
                            return teens[num - 10];
                        } else {
                            return tens[Math.floor(num / 10)] + (num % 10 !== 0 ? ' ' + units[num % 10] : '');
                        }
                    }
                
                    function convertThreeDigit(num) {
                        if (num < 100) {
                            return convertTwoDigit(num);
                        } else {
                            return units[Math.floor(num / 100)] + ' Hundred' + (num % 100 !== 0 ? ' ' + convertTwoDigit(num % 100) : '');
                        }
                    }
                
                    function convertThousand(num) {
                        if (num < 1000) {
                            return convertThreeDigit(num);
                        } else {
                            return convertThreeDigit(Math.floor(num / 1000)) + ' Thousand' + (num % 1000 !== 0 ? ' ' + convertThreeDigit(num % 1000) : '');
                        }
                    }
                
                    function getCurrencyWords(amount) {
                        return amount === 1 ? 'Riyal' : 'Riyals';
                    }
                
                    var words = '';
                
                    var integerPart = Math.floor(number);
                    var decimalPart = Math.round((number - integerPart) * 1000); // Round to three decimal places
                
                    if (integerPart === 0 && decimalPart > 0) {
                        words = 'Zero';
                    } else {
                        words = convertThousand(integerPart) + ' ' + getCurrencyWords(integerPart);
                
                        if (decimalPart > 0) {
                            words += ' and ' + convertThousand(decimalPart) + ' Halalas';
                        }
                    }
                
                    return words.trim();
            }

                
            }
            
            else if (purchase[27] === "BHD") {
                
                function numberToWords(number) {
                    var units = ['', 'One', 'Two', 'Three', 'Four', 'Five', 'Six', 'Seven', 'Eight', 'Nine'];
                    var teens = ['', 'Eleven', 'Twelve', 'Thirteen', 'Fourteen', 'Fifteen', 'Sixteen', 'Seventeen', 'Eighteen', 'Nineteen'];
                    var tens = ['', 'Ten', 'Twenty', 'Thirty', 'Forty', 'Fifty', 'Sixty', 'Seventy', 'Eighty', 'Ninety'];
                
                    function convertTwoDigit(num) {
                        if (num < 10) {
                            return units[num];
                        } else if (num < 20) {
                            return teens[num - 10];
                        } else {
                            return tens[Math.floor(num / 10)] + (num % 10 !== 0 ? ' ' + units[num % 10] : '');
                        }
                    }
                
                    function convertThreeDigit(num) {
                        if (num < 100) {
                            return convertTwoDigit(num);
                        } else {
                            return units[Math.floor(num / 100)] + ' Hundred' + (num % 100 !== 0 ? ' ' + convertTwoDigit(num % 100) : '');
                        }
                    }
                
                    function convertThousand(num) {
                        if (num < 1000) {
                            return convertThreeDigit(num);
                        } else {
                            return convertThreeDigit(Math.floor(num / 1000)) + ' Thousand' + (num % 1000 !== 0 ? ' ' + convertThreeDigit(num % 1000) : '');
                        }
                    }
                
                    function getCurrencyWords(amount) {
                        return amount === 1 ? 'Dinar' : 'Dinars';
                    }
                
                    var words = '';
                
                    var integerPart = Math.floor(number);
                    var decimalPart = Math.round((number - integerPart) * 1000); // Round to three decimal places
                
                    if (integerPart === 0 && decimalPart > 0) {
                        words = 'Zero';
                    } else {
                        words = convertThousand(integerPart) + ' ' + getCurrencyWords(integerPart);
                
                        if (decimalPart > 0) {
                            words += ' and ' + convertThousand(decimalPart) + ' Fils';
                        }
                    }
                
                    return words.trim();
            }

                
            }
            
            
            else{
                
            }
            var newRow = $("<tr>");
            cols = '';
            cols += '<td colspan=8><strong><?php echo e(trans("file.grand total")); ?>: ' + purchase[21] + ' (' + numberToWords(purchase[20]) + ')</strong></td>';
            cols += '<td>'+ purchase[27] + ' ' + purchase[20] + '</td>';
            newRow.append(cols);
            if (parseInt(purchase[20]) === 0) {
                newRow.hide();
            }
            newBody.append(newRow);

                var newRow = $("<tr>");
                cols = '';
                cols += '<td colspan=8><strong><?php echo e(trans("file.grand total")); ?>: (' + numberToWords(purchase[21]) + ')</strong></td>';
                cols += '<td>'+ purchase[27] + ' ' + purchase[21] + '</td>';
                newRow.append(cols);
                newBody.append(newRow);

                var newRow = $("<tr>");
                cols = '';
                cols += '<td colspan=8><strong><?php echo e(trans("file.Due")); ?>:</strong></td>';
                cols += '<td>'+ purchase[27] + ' ' + (purchase[20] - purchase[21]) + '</td>';
                newRow.append(cols);
                newBody.append(newRow);

                 $("table.product-purchase-list").append(newBody);
             }
        });

        var htmlfooter = '<p><strong><?php echo e(trans("file.Note")); ?>:</strong> '+purchase[23]+'</p><strong><?php echo e(trans("file.Created By")); ?>:</strong><br>'+purchase[24]+'<br><div><br><strong>Payment Term:</strong>' + purchase[30] + '<br></div><br><strong>INCO Term:</strong>' + purchase[31] + '<br><br><strong>Your Reference:</strong>' + purchase[32] + '<br><br><strong>Delivery Location:</strong>' + purchase[33];

        $('#purchase-content').html(htmltext);
        $('#purchase-footer').html(htmlfooter);
        $('#purchase-details').modal('show');
    }

    $(document).on('submit', '.payment-form', function(e) {
        if( $('input[name="paying_amount"]').val() < parseFloat($('#amount').val()) ) {
            alert('Paying amount cannot be bigger than recieved amount');
            $('input[name="amount"]').val('');
            $(".change").text(parseFloat( $('input[name="paying_amount"]').val() - $('#amount').val() ).toFixed(<?php echo e($general_setting->decimal); ?>));
            e.preventDefault();
        }
        else if( $('input[name="edit_paying_amount"]').val() < parseFloat($('input[name="edit_amount"]').val()) ) {
            alert('Paying amount cannot be bigger than recieved amount');
            $('input[name="edit_amount"]').val('');
            $(".change").text(parseFloat( $('input[name="edit_paying_amount"]').val() - $('input[name="edit_amount"]').val() ).toFixed(<?php echo e($general_setting->decimal); ?>));
            e.preventDefault();
        }

        $('#edit-payment select[name="edit_paid_by_id"]').prop('disabled', false);
    });

    if(all_permission.indexOf("purchases-delete") == -1)
        $('.buttons-delete').addClass('d-none');


</script>
<script type="text/javascript" src="https://js.stripe.com/v3/"></script>

<script>
    function printContent() {
        var printWindow = window.open('', '_blank');
        var contentToPrint = document.querySelector('.print-container').innerHTML;

        printWindow.document.open();
        printWindow.document.write(`
            <html>
            <head>
                <title>Print</title>
                <style>
                    /* Add any necessary styles for printing here */
                    body {
                        /* Adjust print-specific styles if needed */
                    }
                </style>
            </head>
            <body onload="window.print(); window.onafterprint = function() { window.close(); }">
                ${contentToPrint}
            </body>
            </html>
        `);
        printWindow.document.close();
    }
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/afaqalka/erp-ver01-10.550.15.72.afaqalkawthar.com/resources/views/backend/purchase/index.blade.php ENDPATH**/ ?>